<?php

/**
*
* ZUGFeRD Gateway Version 1.2
* SPE Systemhaus GmbH
* author: Hendrik Diel
* year: 2017
* 
* Description:
* This is a print2forms Gateway script that demonstrates the generation of
* a ZUGFeRD invoice using print2forms p2fzugferd tool and ghostpcl.
* A detailed documentation can be found at http://wiki.print2forms.de/print2forms/tips/tip69.
*
* Dieses print2forms Gateway Skript demonstriert die Erzeugung einer ZUGFeRD-Rechnung
* mithilfe des print2forms Tools p2fzugferd und ghostpcl. Detailierte Informationen sind in unserem
* Wiki unter http://wiki.print2forms.de/print2forms/tips/tip69 verfügbar.
*
**/

const DATE_FIELD = 0;
const CURRENCY_FIELD = 1;
const STRING_FIELD = 2;

	function error($msg){
			echo $msg."\n";
			file_put_contents("zugferd.log", "[" . date('Y-m-d h:i:s', time()) . "] ". $msg."\n", FILE_APPEND);
			die();
	}

chdir(dirname(__FILE__));

file_put_contents("zugferd.log", "[" . date('Y-m-d h:i:s', time()) . "] started\n", FILE_APPEND);

	if($argc < 2)
		error("started without  required params." );

	$xmlpath = "in.xml";
	$xmllinepath = "position.xml";
	$ctlpath = $argv[1].".CTL";
	$pclpath = $argv[1].".PCL";
	$zugferdXMLpath = $argv[1].".xml";
	$pdfpath = $argv[1].".pdf";
	
	$license = $argv[2];
	
	if(!file_exists($xmllinepath))
			error("$xmllinepath not found.. die()");

	if(!file_exists($xmlpath))
			error("$xmlpath not found.. die()");

	if(!file_exists($ctlpath))
			error("$ctlpath not found.. die()");

	if(!file_exists($pclpath))
			error("$pclpath file not found.. die()");

	$xml = file_get_contents($xmlpath);
	$ctl = utf8_encode(file_get_contents($ctlpath));
	$linexml = utf8_encode(file_get_contents($xmllinepath));
	$vars = array();

function processGet($lineIndex, $fieldType = STRING_FIELD){
	echo $lineIndex . ":";
	global $i;
	global $matches;
	while(trim($matches[$i][1]) != trim($lineIndex)){
		$i++;
		if($i>=count($matches))
			die("Failed to find " . $lineIndex);
	}
	echo "$i\n";
	return trim($matches[$i][2]);
}

function process($lineIndex, $targetKey, $fieldType = STRING_FIELD){
	global $vars;
	$vars[$targetKey] = processGet($lineIndex);
	if($fieldType == CURRENCY_FIELD)
		$vars[$targetKey] = formatCurrency($vars[$targetKey]);
	else if($fieldType == DATE_FIELD)
		formatDate($targetKey);
	return $vars[$targetKey];
}

	function unitToUnitCode($unit){
		$ids = array("m²" => "MTK", "kg" => "KGM");
		return $ids[trim($unit)];
	}

	function countryToCountryID($country){
		$ids = array("Deutschland" => "de");
		return $ids[trim($country)];
	}

function formatDate($key){
	global $vars;
	$date = date_parse($vars[$key]);
	$out = $date["year"];
	$out .= strlen($date["month"]) < 2 ? "0".$date["month"] : $date["month"];
	$out .= strlen($date["day"]) < 2 ? "0".$date["day"] : $date["day"];
	$vars[$key] = $out;
}

function formatQuantity($quant){
	$quant = explode(" ", trim($quant))[0];
	$quant = formatCurrency(trim($quant));
	$parts = explode(".", $quant);
	for($i = strlen($parts[count($parts)-1]); $i<4; $i++)
		$quant .= "0";
	return $quant;
}

function formatCurrency($currency){
	return str_replace(",", ".", $currency);
}

	preg_match_all("/\[([0-9][0-9a-zA-Z]+)\](.+)/", $ctl, $matches, PREG_SET_ORDER);

print_r($matches);

$i = 0;

process("01016F00C6","DOC_NAME");
process("01020002DA", "DOC_ID");
process("01024502DA", "DOC_ISSUE_DATE_TIME", DATE_FIELD);
process("01028A02DA", "ACTUAL_DELIVERY_DATE_TIME", DATE_FIELD);
$vars["CUSTOMER_REFERENCE"] = processGet("010200057B") . ": " 
	. processGet("010200078F") . "\n" . processGet("010245057B") . ": ";
$vars["CUSTOMER_ID"] = processGet("010245078F");
$vars["CUSTOMER_REFERENCE"] .= $vars["CUSTOMER_ID"];
process("01039E00C6", "SELLER_NAME");
process("0103E300C6", "SELLER_LINE_ONE");
$plzcity = explode(" ", processGet("01042800C6"));
$vars["SELLER_PLZ"] = $plzcity[0];
$vars["SELLER_CITY_NAME"] = $plzcity[1];
$sellerCountry = processGet("01046D00C6");
$vars["SELLER_COUNTRY_ID"] = countryToCountryID($sellerCountry);

process("01039E057B", "BUYER_NAME");
process("0103E3057B", "BUYER_LINE_ONE");
$plzcity = explode(" ", processGet("010428057B"));
$vars["BUYER_PLZ"] = $plzcity[0];
$vars["BUYER_CITY_NAME"] = $plzcity[1];
$buyerCountry = processGet("01046D057B");
$vars["BUYER_COUNTRY_ID"] = countryToCountryID($buyerCountry);

// Positions Header

$positions = processGet("01054000DC") . " " . processGet("01057A00EE") . "\t" .
			 processGet("010540017D") . " " . processGet("01057A017F") . "\t" .
			 processGet("0105400285") . " " . processGet("01057A0262") . "\t" .
			 processGet("01057A046B") . "\t" .
			 processGet("0105400717") . processGet("01057A070A") . "\t" .
			 processGet("01057A07DE") . "\t" .
			 processGet("01057A08B3") . " " . processGet("010540098A") . " " . processGet("01057A0985");

// positions
$j = 0;
$keys = array("CURRENCY_ID" => "EUR");
$line = $linexml;
$positionmxml = "";
while($matches[++$i][1] != "010D2200C6"){
	$mod = $j++ % 8;
	switch($mod){
		case 0: $positions .= "\n" . trim($matches[$i][2]) . "\t"; break;
		case 1: $keys["NAME"] = trim($matches[$i][2]); $keys["ID"] = $keys["NAME"]; $positions .= trim($matches[$i][2]) . "\t"; break;
		case 2: $keys["NAME"] .= " " . trim($matches[$i][2]); $positions .= trim($matches[$i][2]) . "\t";break;
		case 3: $keys["NAME"] .= " " . trim($matches[$i][2]); $positions .= trim($matches[$i][2]) . "\t";break;
		case 4: $positions .= trim($matches[$i][2]) . "\t"; break;
		case 5: $keys["UNIT_CODE"] = unitToUnitCode($matches[$i][2]); $positions .= trim($matches[$i][2]) . "\t";break;
		case 6: $keys["QUANTITY"] = formatQuantity(trim($matches[$i][2])); $positions .= trim($matches[$i][2]) . "\t";break;
		case 7: $keys["TOTAL"] =  formatCurrency(trim($matches[$i][2]));
							$positions .= trim($matches[$i][2]);
							 //replace placeholder in template
							 foreach ($keys as $key => $value){
							 	$line = str_replace( "@$key@" , trim($value) , $line );
							 }
							 $positionmxml .= $line;
							 $keys = array("CURRENCY_ID" => "EUR");
							 $line = $linexml;
							 
							 break;
		default: break;
	}
}
$vars["POSITIONS_XML"] = $positionmxml;
$vars["POSITIONS"] = $positions;

process("010D220864", "TOTAL_AMOUNT", CURRENCY_FIELD);
$vars["TOTAL_AMOUNT"] = trim(explode(" ",$vars["TOTAL_AMOUNT"])[0]);
$vars["TAX_BASIS_TOTAL_AMOUNT"] = formatCurrency($vars["TOTAL_AMOUNT"]);
$vars["TAX_BASIS_TOTAL_AMOUNT"] = trim(explode(" ",$vars["TAX_BASIS_TOTAL_AMOUNT"])[0]);
$vatLine = processGet("010D6700C6");
$vars["VAT_PERCENTAGE"] = substr(explode(" ", $vatLine)[1], 0, -1) . ".00"; // extract vat percentage, then cut % char
process("010D670864", "TAX_TOTAL_AMOUNT", CURRENCY_FIELD);
$vars["TAX_TOTAL_AMOUNT"] = trim(explode(" ",$vars["TAX_TOTAL_AMOUNT"])[0]);
process("010DAC0864", "GRAND_TOTAL_AMOUNT", CURRENCY_FIELD);
$vars["GRAND_TOTAL_AMOUNT"] = trim(explode(" ",$vars["GRAND_TOTAL_AMOUNT"])[0]);

$vars["CURRENCY_ID"] = "EUR";

// the rest is PAYMENT_INFO

$vars["PAYMENT_INFO"] = "";
while(++$i < count($matches)){
	$vars["PAYMENT_INFO"] .= $matches[$i][2] . "\n";
	if($matches[$i][1] == "010F4B0229"){
		$vars["SELLER_VA_ID"] = $matches[$i][2];
	}
}

//replace placeholder in template
foreach ($vars as $key => $value){
	$xml = str_replace( "@$key@" , trim($value) , $xml );
}

file_put_contents($zugferdXMLpath, $xml);

system("java -jar \"p2fzugferd\p2fzugferd.jar\" --inpcl \"$pclpath\" --gpdl \"p2fzugferd\gpcl6win32.exe\" --xml \"$zugferdXMLpath\" --outpdf \"$pdfpath\" --key \"$license\"");

unlink($zugferdXMLpath);
unlink($pclpath);
unlink($ctlpath);