/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.apache.pdfbox.preflight.utils.ByteArrayDataSource;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTransaction;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.XMPSchemaPDFAExtensions;
import org.mustangproject.ZUGFeRD.XMPSchemaZugferd;
import org.mustangproject.ZUGFeRD.model.AmountType;
import org.mustangproject.ZUGFeRD.model.CodeType;
import org.mustangproject.ZUGFeRD.model.CountryIDType;
import org.mustangproject.ZUGFeRD.model.CreditorFinancialAccountType;
import org.mustangproject.ZUGFeRD.model.CreditorFinancialInstitutionType;
import org.mustangproject.ZUGFeRD.model.CrossIndustryDocumentType;
import org.mustangproject.ZUGFeRD.model.DateTimeType;
import org.mustangproject.ZUGFeRD.model.DocumentCodeType;
import org.mustangproject.ZUGFeRD.model.DocumentContextParameterType;
import org.mustangproject.ZUGFeRD.model.DocumentLineDocumentType;
import org.mustangproject.ZUGFeRD.model.ExchangedDocumentContextType;
import org.mustangproject.ZUGFeRD.model.ExchangedDocumentType;
import org.mustangproject.ZUGFeRD.model.IDType;
import org.mustangproject.ZUGFeRD.model.IndicatorType;
import org.mustangproject.ZUGFeRD.model.LogisticsServiceChargeType;
import org.mustangproject.ZUGFeRD.model.NoteType;
import org.mustangproject.ZUGFeRD.model.ObjectFactory;
import org.mustangproject.ZUGFeRD.model.PaymentMeansCodeType;
import org.mustangproject.ZUGFeRD.model.PercentType;
import org.mustangproject.ZUGFeRD.model.QuantityType;
import org.mustangproject.ZUGFeRD.model.SupplyChainEventType;
import org.mustangproject.ZUGFeRD.model.SupplyChainTradeAgreementType;
import org.mustangproject.ZUGFeRD.model.SupplyChainTradeDeliveryType;
import org.mustangproject.ZUGFeRD.model.SupplyChainTradeLineItemType;
import org.mustangproject.ZUGFeRD.model.SupplyChainTradeSettlementType;
import org.mustangproject.ZUGFeRD.model.SupplyChainTradeTransactionType;
import org.mustangproject.ZUGFeRD.model.TaxCategoryCodeType;
import org.mustangproject.ZUGFeRD.model.TaxRegistrationType;
import org.mustangproject.ZUGFeRD.model.TaxTypeCodeType;
import org.mustangproject.ZUGFeRD.model.TextType;
import org.mustangproject.ZUGFeRD.model.TradeAddressType;
import org.mustangproject.ZUGFeRD.model.TradeAllowanceChargeType;
import org.mustangproject.ZUGFeRD.model.TradePartyType;
import org.mustangproject.ZUGFeRD.model.TradePaymentTermsType;
import org.mustangproject.ZUGFeRD.model.TradePriceType;
import org.mustangproject.ZUGFeRD.model.TradeProductType;
import org.mustangproject.ZUGFeRD.model.TradeSettlementMonetarySummationType;
import org.mustangproject.ZUGFeRD.model.TradeSettlementPaymentMeansType;
import org.mustangproject.ZUGFeRD.model.TradeTaxType;

public class ZUGFeRDExporter {
    private static final Logger LOG = LogManager.getLogger();
    private String conformanceLevel = "U";
    private String versionStr = "1.3.0";
    private String zUGFeRDConformanceLevel = null;
    byte[] zugferdData = null;
    private boolean isTest;
    IZUGFeRDExportableTransaction trans = null;
    private boolean ignoreA1Errors;
    private PDDocument doc;
    private String currency = "EUR";
    private static final ObjectFactory xmlFactory = new ObjectFactory();
    private final JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.mustangproject.ZUGFeRD.model");
    private final Marshaller marshaller = this.jaxbContext.createMarshaller();
    private static final SimpleDateFormat zugferdDateFormat = new SimpleDateFormat("yyyyMMdd");
    private Totals totals;

    public ZUGFeRDExporter() throws JAXBException {
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
    }

    private BigDecimal nDigitFormat(BigDecimal value, int scale) {
        BigDecimal formatedvalue = value.setScale(scale, 4);
        char[] repeat = new char[scale];
        Arrays.fill(repeat, '0');
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols();
        otherSymbols.setDecimalSeparator('.');
        DecimalFormat dec = new DecimalFormat("0." + new String(repeat), otherSymbols);
        return new BigDecimal(dec.format(formatedvalue));
    }

    private BigDecimal vatFormat(BigDecimal value) {
        return this.nDigitFormat(value, 2);
    }

    private BigDecimal currencyFormat(BigDecimal value) {
        return this.nDigitFormat(value, 2);
    }

    private BigDecimal priceFormat(BigDecimal value) {
        return this.nDigitFormat(value, 4);
    }

    private BigDecimal quantityFormat(BigDecimal value) {
        return this.nDigitFormat(value, 4);
    }

    public void setConformanceLevel(String newLevel) {
        this.conformanceLevel = newLevel;
    }

    public void setTest() {
        this.isTest = true;
    }

    public void ignoreA1Errors() {
        this.ignoreA1Errors = true;
    }

    private boolean getA1ParserValidationResult(PreflightParser parser) {
        ValidationResult result = null;
        try {
            parser.parse();
            PreflightDocument document = parser.getPreflightDocument();
            document.validate();
            result = document.getResult();
            document.close();
        }
        catch (IOException e) {
            LOG.catching(e);
            return false;
        }
        return result.isValid();
    }

    public boolean isValidA1(String filename) {
        PreflightParser parser;
        try {
            parser = new PreflightParser(filename);
        }
        catch (IOException e) {
            LOG.catching(e);
            return false;
        }
        return this.getA1ParserValidationResult(parser);
    }

    public boolean isValidA1(InputStream filestream) {
        ByteArrayDataSource fd = null;
        try {
            fd = new ByteArrayDataSource(filestream);
            PreflightParser parser = new PreflightParser(fd);
            return this.getA1ParserValidationResult(parser);
        }
        catch (IOException e) {
            LOG.catching(e);
            return false;
        }
    }

    public void loadPDFA3(String filename) {
        try {
            File f = new File(filename);
            this.doc = PDDocument.load(f);
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    public void loadPDFA3(InputStream filestream) {
        try {
            this.doc = PDDocument.load(filestream);
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @Deprecated
    public PDDocumentCatalog PDFmakeA3compliant(String filename, String producer, String creator, boolean attachZugferdHeaders) throws IOException, TransformerException, BadFieldValueException {
        return this.createPDFmakeA3compliant(filename, producer, creator, attachZugferdHeaders);
    }

    public PDDocumentCatalog createPDFmakeA3compliant(String filename, String producer, String creator, boolean attachZugferdHeaders) throws IOException, TransformerException, BadFieldValueException {
        if (!this.ignoreA1Errors && !this.isValidA1(filename)) {
            throw new IOException("File is not a valid PDF/A-1 input file");
        }
        this.loadPDFA3(filename);
        return this.makeDocPDFA3compliant(producer, creator, attachZugferdHeaders);
    }

    @Deprecated
    public PDDocumentCatalog PDFmakeA3compliant(InputStream file, String producer, String creator, boolean attachZugferdHeaders) throws IOException, TransformerException, BadFieldValueException {
        return this.createPDFmakeA3compliant(file, producer, creator, attachZugferdHeaders);
    }

    public PDDocumentCatalog createPDFmakeA3compliant(InputStream file, String producer, String creator, boolean attachZugferdHeaders) throws IOException, TransformerException, BadFieldValueException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        while ((n = file.read(buf)) >= 0) {
            baos.write(buf, 0, n);
        }
        byte[] content = baos.toByteArray();
        ByteArrayInputStream is1 = new ByteArrayInputStream(content);
        if (!this.ignoreA1Errors && !this.isValidA1(is1)) {
            throw new IOException("File is not a valid PDF/A-1 input file");
        }
        ByteArrayInputStream is2 = new ByteArrayInputStream(content);
        this.loadPDFA3(is2);
        return this.makeDocPDFA3compliant(producer, creator, attachZugferdHeaders);
    }

    private PDDocumentCatalog makeDocPDFA3compliant(String producer, String creator, boolean attachZugferdHeaders) throws IOException, TransformerException, BadFieldValueException {
        String fullProducer = producer + " (via mustangproject.org " + this.versionStr + ")";
        PDDocumentCatalog cat = this.doc.getDocumentCatalog();
        PDMetadata metadata = new PDMetadata(this.doc);
        cat.setMetadata(metadata);
        XMPMetadata xmp = XMPMetadata.createXMPMetadata();
        PDFAIdentificationSchema pdfaid = xmp.createAndAddPFAIdentificationSchema();
        DublinCoreSchema dc = xmp.createAndAddDublinCoreSchema();
        dc.addCreator(creator);
        XMPBasicSchema xsb = xmp.createAndAddXMPBasicSchema();
        xsb.setCreatorTool(creator);
        xsb.setCreateDate(Calendar.getInstance());
        PDDocumentInformation pdi = new PDDocumentInformation();
        pdi.setProducer(fullProducer);
        pdi.setAuthor(creator);
        this.doc.setDocumentInformation(pdi);
        AdobePDFSchema pdf = xmp.createAndAddAdobePDFSchema();
        pdf.setProducer(fullProducer);
        pdfaid.setConformance(this.conformanceLevel);
        pdfaid.setPart(3);
        if (attachZugferdHeaders) {
            this.addZugferdXMP(xmp);
        }
        XmpSerializer serializer = new XmpSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.serialize(xmp, baos, true);
        metadata.importXMPMetadata(baos.toByteArray());
        return cat;
    }

    private String getZugferdXMLForTransaction(IZUGFeRDExportableTransaction transaction) throws JAXBException {
        this.trans = transaction;
        this.totals = new Totals();
        this.currency = transaction.getCurrency();
        CrossIndustryDocumentType invoice = xmlFactory.createCrossIndustryDocumentType();
        invoice.setSpecifiedExchangedDocumentContext(this.getDocumentContext());
        invoice.setHeaderExchangedDocument(this.getDocument());
        invoice.setSpecifiedSupplyChainTradeTransaction(this.getTradeTransaction());
        JAXBElement<CrossIndustryDocumentType> jaxElement = xmlFactory.createCrossIndustryDocument(invoice);
        ByteArrayOutputStream outputXml = new ByteArrayOutputStream();
        this.marshaller.marshal(jaxElement, (OutputStream)outputXml);
        return outputXml.toString();
    }

    private ExchangedDocumentContextType getDocumentContext() {
        ExchangedDocumentContextType context = xmlFactory.createExchangedDocumentContextType();
        DocumentContextParameterType contextParameter = xmlFactory.createDocumentContextParameterType();
        IDType idType = xmlFactory.createIDType();
        idType.setValue("urn:ferd:CrossIndustryDocument:invoice:1p0:extended");
        contextParameter.setID(idType);
        context.getGuidelineSpecifiedDocumentContextParameter().add(contextParameter);
        IndicatorType testIndicator = xmlFactory.createIndicatorType();
        testIndicator.setIndicator(this.isTest);
        context.setTestIndicator(testIndicator);
        return context;
    }

    private ExchangedDocumentType getDocument() {
        ExchangedDocumentType document = xmlFactory.createExchangedDocumentType();
        IDType id = xmlFactory.createIDType();
        id.setValue(this.trans.getNumber());
        document.setID(id);
        DateTimeType issueDateTime = xmlFactory.createDateTimeType();
        DateTimeType.DateTimeString issueDateTimeString = xmlFactory.createDateTimeTypeDateTimeString();
        issueDateTimeString.setFormat("102");
        issueDateTimeString.setValue(zugferdDateFormat.format(this.trans.getIssueDate()));
        issueDateTime.setDateTimeString(issueDateTimeString);
        document.setIssueDateTime(issueDateTime);
        DocumentCodeType documentCodeType = xmlFactory.createDocumentCodeType();
        documentCodeType.setValue("380");
        document.setTypeCode(documentCodeType);
        TextType name = xmlFactory.createTextType();
        name.setValue("RECHNUNG");
        document.getName().add(name);
        if (this.trans.getOwnOrganisationFullPlaintextInfo() != null) {
            NoteType regularInfo = xmlFactory.createNoteType();
            CodeType regularInfoSubjectCode = xmlFactory.createCodeType();
            regularInfoSubjectCode.setValue("REG");
            regularInfo.setSubjectCode(regularInfoSubjectCode);
            TextType regularInfoContent = xmlFactory.createTextType();
            regularInfoContent.setValue(this.trans.getOwnOrganisationFullPlaintextInfo());
            regularInfo.getContent().add(regularInfoContent);
            document.getIncludedNote().add(regularInfo);
        }
        return document;
    }

    private SupplyChainTradeTransactionType getTradeTransaction() {
        SupplyChainTradeTransactionType transaction = xmlFactory.createSupplyChainTradeTransactionType();
        transaction.getApplicableSupplyChainTradeAgreement().add(this.getTradeAgreement());
        transaction.setApplicableSupplyChainTradeDelivery(this.getTradeDelivery());
        transaction.setApplicableSupplyChainTradeSettlement(this.getTradeSettlement());
        transaction.getIncludedSupplyChainTradeLineItem().addAll(this.getLineItems());
        return transaction;
    }

    private SupplyChainTradeAgreementType getTradeAgreement() {
        SupplyChainTradeAgreementType tradeAgreement = xmlFactory.createSupplyChainTradeAgreementType();
        tradeAgreement.setBuyerTradeParty(this.getBuyer());
        tradeAgreement.setSellerTradeParty(this.getSeller());
        return tradeAgreement;
    }

    private TradePartyType getBuyer() {
        TradePartyType buyerTradeParty = xmlFactory.createTradePartyType();
        TextType buyerName = xmlFactory.createTextType();
        buyerName.setValue(this.trans.getRecipient().getName());
        buyerTradeParty.setName(buyerName);
        TradeAddressType buyerAddressType = xmlFactory.createTradeAddressType();
        TextType buyerCityName = xmlFactory.createTextType();
        buyerCityName.setValue(this.trans.getRecipient().getLocation());
        buyerAddressType.setCityName(buyerCityName);
        CountryIDType buyerCountryId = xmlFactory.createCountryIDType();
        buyerCountryId.setValue(this.trans.getRecipient().getCountry());
        buyerAddressType.setCountryID(buyerCountryId);
        TextType buyerAddress = xmlFactory.createTextType();
        buyerAddress.setValue(this.trans.getRecipient().getStreet());
        buyerAddressType.setLineOne(buyerAddress);
        CodeType buyerPostcode = xmlFactory.createCodeType();
        buyerPostcode.setValue(this.trans.getRecipient().getZIP());
        buyerAddressType.getPostcodeCode().add(buyerPostcode);
        buyerTradeParty.setPostalTradeAddress(buyerAddressType);
        TaxRegistrationType buyerTaxRegistration = xmlFactory.createTaxRegistrationType();
        IDType buyerUstId = xmlFactory.createIDType();
        buyerUstId.setValue(this.trans.getRecipient().getVATID());
        buyerUstId.setSchemeID("VA");
        buyerTaxRegistration.setID(buyerUstId);
        buyerTradeParty.getSpecifiedTaxRegistration().add(buyerTaxRegistration);
        return buyerTradeParty;
    }

    private TradePartyType getSeller() {
        TradePartyType sellerTradeParty = xmlFactory.createTradePartyType();
        TextType sellerName = xmlFactory.createTextType();
        sellerName.setValue(this.trans.getOwnOrganisationName());
        sellerTradeParty.setName(sellerName);
        TradeAddressType sellerAddressType = xmlFactory.createTradeAddressType();
        TextType sellerCityName = xmlFactory.createTextType();
        sellerCityName.setValue(this.trans.getOwnLocation());
        sellerAddressType.setCityName(sellerCityName);
        CountryIDType sellerCountryId = xmlFactory.createCountryIDType();
        sellerCountryId.setValue(this.trans.getOwnCountry());
        sellerAddressType.setCountryID(sellerCountryId);
        TextType sellerAddress = xmlFactory.createTextType();
        sellerAddress.setValue(this.trans.getOwnStreet());
        sellerAddressType.setLineOne(sellerAddress);
        CodeType sellerPostcode = xmlFactory.createCodeType();
        sellerPostcode.setValue(this.trans.getOwnZIP());
        sellerAddressType.getPostcodeCode().add(sellerPostcode);
        sellerTradeParty.setPostalTradeAddress(sellerAddressType);
        TaxRegistrationType sellerTaxRegistration = xmlFactory.createTaxRegistrationType();
        IDType sellerTaxId = xmlFactory.createIDType();
        sellerTaxId.setValue(this.trans.getOwnTaxID());
        sellerTaxId.setSchemeID("FC");
        sellerTaxRegistration.setID(sellerTaxId);
        sellerTradeParty.getSpecifiedTaxRegistration().add(sellerTaxRegistration);
        sellerTaxRegistration = xmlFactory.createTaxRegistrationType();
        IDType sellerUstId = xmlFactory.createIDType();
        sellerUstId.setValue(this.trans.getOwnVATID());
        sellerUstId.setSchemeID("VA");
        sellerTaxRegistration.setID(sellerUstId);
        sellerTradeParty.getSpecifiedTaxRegistration().add(sellerTaxRegistration);
        return sellerTradeParty;
    }

    private SupplyChainTradeDeliveryType getTradeDelivery() {
        SupplyChainTradeDeliveryType tradeDelivery = xmlFactory.createSupplyChainTradeDeliveryType();
        SupplyChainEventType deliveryEvent = xmlFactory.createSupplyChainEventType();
        DateTimeType deliveryDate = xmlFactory.createDateTimeType();
        DateTimeType.DateTimeString deliveryDateString = xmlFactory.createDateTimeTypeDateTimeString();
        deliveryDateString.setFormat("102");
        deliveryDateString.setValue(zugferdDateFormat.format(this.trans.getDeliveryDate()));
        deliveryDate.setDateTimeString(deliveryDateString);
        deliveryEvent.getOccurrenceDateTime().add(deliveryDate);
        tradeDelivery.getActualDeliverySupplyChainEvent().add(deliveryEvent);
        return tradeDelivery;
    }

    private SupplyChainTradeSettlementType getTradeSettlement() {
        SupplyChainTradeSettlementType tradeSettlement = xmlFactory.createSupplyChainTradeSettlementType();
        TextType paymentReference = xmlFactory.createTextType();
        paymentReference.setValue(this.trans.getNumber());
        tradeSettlement.getPaymentReference().add(paymentReference);
        CodeType currencyCode = xmlFactory.createCodeType();
        currencyCode.setValue(this.currency);
        tradeSettlement.setInvoiceCurrencyCode(currencyCode);
        tradeSettlement.getSpecifiedTradeSettlementPaymentMeans().add(this.getPaymentData());
        tradeSettlement.getApplicableTradeTax().addAll(this.getTradeTax());
        tradeSettlement.getSpecifiedTradePaymentTerms().addAll(this.getPaymentTerms());
        if (this.trans.getZFAllowances() != null) {
            tradeSettlement.getSpecifiedTradeAllowanceCharge().addAll(this.getHeaderAllowances());
        }
        if (this.trans.getZFLogisticsServiceCharges() != null) {
            tradeSettlement.getSpecifiedLogisticsServiceCharge().addAll(this.getHeaderLogisticsServiceCharges());
        }
        if (this.trans.getZFCharges() != null) {
            tradeSettlement.getSpecifiedTradeAllowanceCharge().addAll(this.getHeaderCharges());
        }
        tradeSettlement.setSpecifiedTradeSettlementMonetarySummation(this.getMonetarySummation());
        return tradeSettlement;
    }

    private TradeSettlementPaymentMeansType getPaymentData() {
        TradeSettlementPaymentMeansType paymentData = xmlFactory.createTradeSettlementPaymentMeansType();
        PaymentMeansCodeType paymentDataType = xmlFactory.createPaymentMeansCodeType();
        paymentDataType.setValue("42");
        paymentData.setTypeCode(paymentDataType);
        TextType paymentInfo = xmlFactory.createTextType();
        String paymentInfoText = this.trans.getOwnPaymentInfoText();
        if (paymentInfoText == null) {
            paymentInfoText = "";
        }
        paymentInfo.setValue(paymentInfoText);
        paymentData.getInformation().add(paymentInfo);
        CreditorFinancialAccountType bankAccount = xmlFactory.createCreditorFinancialAccountType();
        IDType iban = xmlFactory.createIDType();
        iban.setValue(this.trans.getOwnIBAN());
        bankAccount.setIBANID(iban);
        paymentData.setPayeePartyCreditorFinancialAccount(bankAccount);
        CreditorFinancialInstitutionType bankData = xmlFactory.createCreditorFinancialInstitutionType();
        IDType bicId = xmlFactory.createIDType();
        bicId.setValue(this.trans.getOwnBIC());
        bankData.setBICID(bicId);
        TextType bankName = xmlFactory.createTextType();
        bankName.setValue(this.trans.getOwnBankName());
        bankData.setName(bankName);
        paymentData.setPayeeSpecifiedCreditorFinancialInstitution(bankData);
        return paymentData;
    }

    private Collection<TradeTaxType> getTradeTax() {
        ArrayList<TradeTaxType> tradeTaxTypes = new ArrayList<TradeTaxType>();
        HashMap<BigDecimal, VATAmount> vatPercentAmountMap = this.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent : vatPercentAmountMap.keySet()) {
            TradeTaxType tradeTax = xmlFactory.createTradeTaxType();
            TaxTypeCodeType taxTypeCode = xmlFactory.createTaxTypeCodeType();
            taxTypeCode.setValue("VAT");
            tradeTax.setTypeCode(taxTypeCode);
            TaxCategoryCodeType taxCategoryCode = xmlFactory.createTaxCategoryCodeType();
            taxCategoryCode.setValue("S");
            tradeTax.setCategoryCode(taxCategoryCode);
            VATAmount amount = vatPercentAmountMap.get(currentTaxPercent);
            PercentType taxPercent = xmlFactory.createPercentType();
            taxPercent.setValue(this.vatFormat(currentTaxPercent));
            tradeTax.setApplicablePercent(taxPercent);
            AmountType calculatedTaxAmount = xmlFactory.createAmountType();
            calculatedTaxAmount.setCurrencyID(this.currency);
            calculatedTaxAmount.setValue(this.currencyFormat(amount.getCalculated()));
            tradeTax.getCalculatedAmount().add(calculatedTaxAmount);
            AmountType basisTaxAmount = xmlFactory.createAmountType();
            basisTaxAmount.setCurrencyID(this.currency);
            basisTaxAmount.setValue(this.currencyFormat(amount.getBasis()));
            tradeTax.getBasisAmount().add(basisTaxAmount);
            tradeTaxTypes.add(tradeTax);
        }
        return tradeTaxTypes;
    }

    private Collection<TradeAllowanceChargeType> getHeaderAllowances() {
        ArrayList<TradeAllowanceChargeType> headerAllowances = new ArrayList<TradeAllowanceChargeType>();
        for (IZUGFeRDAllowanceCharge iAllowance : this.trans.getZFAllowances()) {
            TradeAllowanceChargeType allowance = xmlFactory.createTradeAllowanceChargeType();
            IndicatorType chargeIndicator = xmlFactory.createIndicatorType();
            chargeIndicator.setIndicator(false);
            allowance.setChargeIndicator(chargeIndicator);
            AmountType actualAmount = xmlFactory.createAmountType();
            actualAmount.setCurrencyID(this.currency);
            actualAmount.setValue(this.currencyFormat(iAllowance.getTotalAmount()));
            allowance.getActualAmount().add(actualAmount);
            TextType reason = xmlFactory.createTextType();
            reason.setValue(iAllowance.getReason());
            allowance.setReason(reason);
            TradeTaxType tradeTax = xmlFactory.createTradeTaxType();
            PercentType vatPercent = xmlFactory.createPercentType();
            vatPercent.setValue(this.currencyFormat(iAllowance.getTaxPercent()));
            tradeTax.setApplicablePercent(vatPercent);
            TaxCategoryCodeType taxType = xmlFactory.createTaxCategoryCodeType();
            taxType.setValue("S");
            tradeTax.setCategoryCode(taxType);
            TaxTypeCodeType taxCode = xmlFactory.createTaxTypeCodeType();
            taxCode.setValue("VAT");
            tradeTax.setTypeCode(taxCode);
            allowance.getCategoryTradeTax().add(tradeTax);
            headerAllowances.add(allowance);
        }
        return headerAllowances;
    }

    private Collection<TradeAllowanceChargeType> getHeaderCharges() {
        ArrayList<TradeAllowanceChargeType> headerCharges = new ArrayList<TradeAllowanceChargeType>();
        for (IZUGFeRDAllowanceCharge iCharge : this.trans.getZFCharges()) {
            TradeAllowanceChargeType charge = xmlFactory.createTradeAllowanceChargeType();
            IndicatorType chargeIndicator = xmlFactory.createIndicatorType();
            chargeIndicator.setIndicator(true);
            charge.setChargeIndicator(chargeIndicator);
            AmountType actualAmount = xmlFactory.createAmountType();
            actualAmount.setCurrencyID(this.currency);
            actualAmount.setValue(this.currencyFormat(iCharge.getTotalAmount()));
            charge.getActualAmount().add(actualAmount);
            TextType reason = xmlFactory.createTextType();
            reason.setValue(iCharge.getReason());
            charge.setReason(reason);
            TradeTaxType tradeTax = xmlFactory.createTradeTaxType();
            PercentType vatPercent = xmlFactory.createPercentType();
            vatPercent.setValue(this.currencyFormat(iCharge.getTaxPercent()));
            tradeTax.setApplicablePercent(vatPercent);
            TaxCategoryCodeType taxType = xmlFactory.createTaxCategoryCodeType();
            taxType.setValue("S");
            tradeTax.setCategoryCode(taxType);
            TaxTypeCodeType taxCode = xmlFactory.createTaxTypeCodeType();
            taxCode.setValue("VAT");
            tradeTax.setTypeCode(taxCode);
            charge.getCategoryTradeTax().add(tradeTax);
            headerCharges.add(charge);
        }
        return headerCharges;
    }

    private Collection<LogisticsServiceChargeType> getHeaderLogisticsServiceCharges() {
        ArrayList<LogisticsServiceChargeType> headerServiceCharge = new ArrayList<LogisticsServiceChargeType>();
        for (IZUGFeRDAllowanceCharge iServiceCharge : this.trans.getZFLogisticsServiceCharges()) {
            LogisticsServiceChargeType serviceCharge = xmlFactory.createLogisticsServiceChargeType();
            AmountType actualAmount = xmlFactory.createAmountType();
            actualAmount.setCurrencyID(this.currency);
            actualAmount.setValue(this.currencyFormat(iServiceCharge.getTotalAmount()));
            serviceCharge.getAppliedAmount().add(actualAmount);
            TextType reason = xmlFactory.createTextType();
            reason.setValue(iServiceCharge.getReason());
            serviceCharge.getDescription().add(reason);
            TradeTaxType tradeTax = xmlFactory.createTradeTaxType();
            PercentType vatPercent = xmlFactory.createPercentType();
            vatPercent.setValue(this.currencyFormat(iServiceCharge.getTaxPercent()));
            tradeTax.setApplicablePercent(vatPercent);
            TaxCategoryCodeType taxType = xmlFactory.createTaxCategoryCodeType();
            taxType.setValue("S");
            tradeTax.setCategoryCode(taxType);
            TaxTypeCodeType taxCode = xmlFactory.createTaxTypeCodeType();
            taxCode.setValue("VAT");
            tradeTax.setTypeCode(taxCode);
            serviceCharge.getAppliedTradeTax().add(tradeTax);
            headerServiceCharge.add(serviceCharge);
        }
        return headerServiceCharge;
    }

    private Collection<TradePaymentTermsType> getPaymentTerms() {
        ArrayList<TradePaymentTermsType> paymentTerms = new ArrayList<TradePaymentTermsType>();
        TradePaymentTermsType paymentTerm = xmlFactory.createTradePaymentTermsType();
        DateTimeType dueDate = xmlFactory.createDateTimeType();
        DateTimeType.DateTimeString dueDateString = xmlFactory.createDateTimeTypeDateTimeString();
        dueDateString.setFormat("102");
        dueDateString.setValue(zugferdDateFormat.format(this.trans.getDueDate()));
        dueDate.setDateTimeString(dueDateString);
        paymentTerm.setDueDateDateTime(dueDate);
        TextType paymentTermDescr = xmlFactory.createTextType();
        String paymentTermDescription = this.trans.getPaymentTermDescription();
        if (paymentTermDescription == null) {
            paymentTermDescription = "";
        }
        paymentTermDescr.setValue(paymentTermDescription);
        paymentTerm.getDescription().add(paymentTermDescr);
        paymentTerms.add(paymentTerm);
        return paymentTerms;
    }

    private TradeSettlementMonetarySummationType getMonetarySummation() {
        TradeSettlementMonetarySummationType monetarySummation = xmlFactory.createTradeSettlementMonetarySummationType();
        AmountType allowanceTotalAmount = xmlFactory.createAmountType();
        allowanceTotalAmount.setCurrencyID(this.currency);
        if (this.trans.getZFAllowances() != null) {
            BigDecimal totalHeaderAllowance = BigDecimal.ZERO;
            for (IZUGFeRDAllowanceCharge headerAllowance : this.trans.getZFAllowances()) {
                totalHeaderAllowance = headerAllowance.getTotalAmount().add(totalHeaderAllowance);
            }
            allowanceTotalAmount.setValue(this.currencyFormat(totalHeaderAllowance));
        } else {
            allowanceTotalAmount.setValue(this.currencyFormat(BigDecimal.ZERO));
        }
        monetarySummation.getAllowanceTotalAmount().add(allowanceTotalAmount);
        BigDecimal totalCharge = BigDecimal.ZERO;
        AmountType totalChargeAmount = xmlFactory.createAmountType();
        totalChargeAmount.setCurrencyID(this.currency);
        if (this.trans.getZFLogisticsServiceCharges() != null) {
            for (IZUGFeRDAllowanceCharge logisticsServiceCharge : this.trans.getZFLogisticsServiceCharges()) {
                totalCharge = logisticsServiceCharge.getTotalAmount().add(totalCharge);
            }
        }
        if (this.trans.getZFCharges() != null) {
            for (IZUGFeRDAllowanceCharge charge : this.trans.getZFCharges()) {
                totalCharge = charge.getTotalAmount().add(totalCharge);
            }
        }
        totalChargeAmount.setValue(this.currencyFormat(totalCharge));
        monetarySummation.getChargeTotalAmount().add(totalChargeAmount);
        AmountType lineTotalAmount = xmlFactory.createAmountType();
        lineTotalAmount.setCurrencyID(this.currency);
        lineTotalAmount.setValue(this.currencyFormat(this.totals.getLineTotal()));
        monetarySummation.getLineTotalAmount().add(lineTotalAmount);
        AmountType taxBasisTotalAmount = xmlFactory.createAmountType();
        taxBasisTotalAmount.setCurrencyID(this.currency);
        taxBasisTotalAmount.setValue(this.currencyFormat(this.totals.getTotalNet()));
        monetarySummation.getTaxBasisTotalAmount().add(taxBasisTotalAmount);
        AmountType taxTotalAmount = xmlFactory.createAmountType();
        taxTotalAmount.setCurrencyID(this.currency);
        taxTotalAmount.setValue(this.currencyFormat(this.totals.getTaxTotal()));
        monetarySummation.getTaxTotalAmount().add(taxTotalAmount);
        AmountType grandTotalAmount = xmlFactory.createAmountType();
        grandTotalAmount.setCurrencyID(this.currency);
        grandTotalAmount.setValue(this.currencyFormat(this.totals.getTotalGross()));
        monetarySummation.getGrandTotalAmount().add(grandTotalAmount);
        AmountType duePayableAmount = xmlFactory.createAmountType();
        duePayableAmount.setCurrencyID(this.currency);
        duePayableAmount.setValue(this.currencyFormat(this.totals.getTotalGross()));
        monetarySummation.getDuePayableAmount().add(duePayableAmount);
        return monetarySummation;
    }

    private Collection<SupplyChainTradeLineItemType> getLineItems() {
        ArrayList<SupplyChainTradeLineItemType> lineItems = new ArrayList<SupplyChainTradeLineItemType>();
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : this.trans.getZFItems()) {
            LineCalc lc = new LineCalc(currentItem);
            SupplyChainTradeLineItemType lineItem = xmlFactory.createSupplyChainTradeLineItemType();
            DocumentLineDocumentType lineDocument = xmlFactory.createDocumentLineDocumentType();
            IDType lineNumber = xmlFactory.createIDType();
            lineNumber.setValue(Integer.toString(++lineID));
            lineDocument.setLineID(lineNumber);
            lineItem.setAssociatedDocumentLineDocument(lineDocument);
            SupplyChainTradeAgreementType tradeAgreement = xmlFactory.createSupplyChainTradeAgreementType();
            TradePriceType grossTradePrice = xmlFactory.createTradePriceType();
            QuantityType grossQuantity = xmlFactory.createQuantityType();
            grossQuantity.setUnitCode(currentItem.getProduct().getUnit());
            grossQuantity.setValue(this.quantityFormat(BigDecimal.ONE));
            grossTradePrice.setBasisQuantity(grossQuantity);
            AmountType grossChargeAmount = xmlFactory.createAmountType();
            grossChargeAmount.setCurrencyID(this.currency);
            grossChargeAmount.setValue(this.priceFormat(currentItem.getPrice()));
            grossTradePrice.getChargeAmount().add(grossChargeAmount);
            tradeAgreement.getGrossPriceProductTradePrice().add(grossTradePrice);
            if (currentItem.getItemAllowances() != null) {
                for (IZUGFeRDAllowanceCharge itemAllowance : currentItem.getItemAllowances()) {
                    TradeAllowanceChargeType eItemAllowance = xmlFactory.createTradeAllowanceChargeType();
                    IndicatorType chargeIndicator = xmlFactory.createIndicatorType();
                    chargeIndicator.setIndicator(false);
                    eItemAllowance.setChargeIndicator(chargeIndicator);
                    AmountType actualAmount = xmlFactory.createAmountType();
                    actualAmount.setCurrencyID(this.currency);
                    actualAmount.setValue(this.priceFormat(itemAllowance.getTotalAmount().divide(currentItem.getQuantity(), 4, 4)));
                    eItemAllowance.getActualAmount().add(actualAmount);
                    TextType reason = xmlFactory.createTextType();
                    reason.setValue(itemAllowance.getReason());
                    eItemAllowance.setReason(reason);
                    grossTradePrice.getAppliedTradeAllowanceCharge().add(eItemAllowance);
                }
            }
            if (currentItem.getItemCharges() != null) {
                for (IZUGFeRDAllowanceCharge itemCharge : currentItem.getItemCharges()) {
                    TradeAllowanceChargeType eItemCharge = xmlFactory.createTradeAllowanceChargeType();
                    AmountType actualAmount = xmlFactory.createAmountType();
                    actualAmount.setCurrencyID(this.currency);
                    actualAmount.setValue(this.priceFormat(itemCharge.getTotalAmount().divide(currentItem.getQuantity(), 4, 4)));
                    eItemCharge.getActualAmount().add(actualAmount);
                    TextType reason = xmlFactory.createTextType();
                    reason.setValue(itemCharge.getReason());
                    eItemCharge.setReason(reason);
                    IndicatorType chargeIndicator = xmlFactory.createIndicatorType();
                    chargeIndicator.setIndicator(true);
                    eItemCharge.setChargeIndicator(chargeIndicator);
                    grossTradePrice.getAppliedTradeAllowanceCharge().add(eItemCharge);
                }
            }
            TradePriceType netTradePrice = xmlFactory.createTradePriceType();
            QuantityType netQuantity = xmlFactory.createQuantityType();
            netQuantity.setUnitCode(currentItem.getProduct().getUnit());
            netQuantity.setValue(this.quantityFormat(BigDecimal.ONE));
            netTradePrice.setBasisQuantity(netQuantity);
            AmountType netChargeAmount = xmlFactory.createAmountType();
            netChargeAmount.setCurrencyID(this.currency);
            netChargeAmount.setValue(this.priceFormat(lc.getItemNetAmount()));
            netTradePrice.getChargeAmount().add(netChargeAmount);
            tradeAgreement.getNetPriceProductTradePrice().add(netTradePrice);
            lineItem.setSpecifiedSupplyChainTradeAgreement(tradeAgreement);
            SupplyChainTradeDeliveryType tradeDelivery = xmlFactory.createSupplyChainTradeDeliveryType();
            QuantityType billedQuantity = xmlFactory.createQuantityType();
            billedQuantity.setUnitCode(currentItem.getProduct().getUnit());
            billedQuantity.setValue(this.quantityFormat(currentItem.getQuantity()));
            tradeDelivery.setBilledQuantity(billedQuantity);
            lineItem.setSpecifiedSupplyChainTradeDelivery(tradeDelivery);
            SupplyChainTradeSettlementType tradeSettlement = xmlFactory.createSupplyChainTradeSettlementType();
            TradeTaxType tradeTax = xmlFactory.createTradeTaxType();
            TaxCategoryCodeType taxCategoryCode = xmlFactory.createTaxCategoryCodeType();
            taxCategoryCode.setValue("S");
            tradeTax.setCategoryCode(taxCategoryCode);
            TaxTypeCodeType taxCode = xmlFactory.createTaxTypeCodeType();
            taxCode.setValue("VAT");
            tradeTax.setTypeCode(taxCode);
            PercentType taxPercent = xmlFactory.createPercentType();
            taxPercent.setValue(this.vatFormat(currentItem.getProduct().getVATPercent()));
            tradeTax.setApplicablePercent(taxPercent);
            tradeSettlement.getApplicableTradeTax().add(tradeTax);
            TradeSettlementMonetarySummationType monetarySummation = xmlFactory.createTradeSettlementMonetarySummationType();
            AmountType itemAmount = xmlFactory.createAmountType();
            itemAmount.setCurrencyID(this.currency);
            itemAmount.setValue(this.currencyFormat(lc.getItemTotalNetAmount()));
            monetarySummation.getLineTotalAmount().add(itemAmount);
            tradeSettlement.setSpecifiedTradeSettlementMonetarySummation(monetarySummation);
            lineItem.setSpecifiedSupplyChainTradeSettlement(tradeSettlement);
            TradeProductType tradeProduct = xmlFactory.createTradeProductType();
            TextType productName = xmlFactory.createTextType();
            productName.setValue(currentItem.getProduct().getName());
            tradeProduct.getName().add(productName);
            TextType productDescription = xmlFactory.createTextType();
            productDescription.setValue(currentItem.getProduct().getDescription());
            tradeProduct.getDescription().add(productDescription);
            lineItem.setSpecifiedTradeProduct(tradeProduct);
            lineItems.add(lineItem);
        }
        return lineItems;
    }

    private HashMap<BigDecimal, VATAmount> getVATPercentAmountMap() {
        return this.getVATPercentAmountMap(false);
    }

    private HashMap<BigDecimal, VATAmount> getVATPercentAmountMap(Boolean itemOnly) {
        VATAmount current;
        VATAmount itemVATAmount;
        BigDecimal percent;
        HashMap<BigDecimal, VATAmount> hm = new HashMap<BigDecimal, VATAmount>();
        for (IZUGFeRDExportableItem currentItem : this.trans.getZFItems()) {
            percent = currentItem.getProduct().getVATPercent();
            LineCalc lc = new LineCalc(currentItem);
            VATAmount itemVATAmount2 = new VATAmount(lc.getItemTotalNetAmount(), lc.getItemTotalVATAmount());
            VATAmount current2 = hm.get(percent);
            if (current2 == null) {
                hm.put(percent, itemVATAmount2);
                continue;
            }
            hm.put(percent, current2.add(itemVATAmount2));
        }
        if (itemOnly.booleanValue()) {
            return hm;
        }
        if (this.trans.getZFAllowances() != null) {
            for (IZUGFeRDAllowanceCharge headerAllowance : this.trans.getZFAllowances()) {
                percent = headerAllowance.getTaxPercent();
                itemVATAmount = new VATAmount(headerAllowance.getTotalAmount(), headerAllowance.getTotalAmount().multiply(percent).divide(new BigDecimal(100)));
                current = hm.get(percent);
                if (current == null) {
                    hm.put(percent, itemVATAmount);
                    continue;
                }
                hm.put(percent, current.subtract(itemVATAmount));
            }
        }
        if (this.trans.getZFLogisticsServiceCharges() != null) {
            for (IZUGFeRDAllowanceCharge logisticsServiceCharge : this.trans.getZFLogisticsServiceCharges()) {
                percent = logisticsServiceCharge.getTaxPercent();
                itemVATAmount = new VATAmount(logisticsServiceCharge.getTotalAmount(), logisticsServiceCharge.getTotalAmount().multiply(percent).divide(new BigDecimal(100)));
                current = hm.get(percent);
                if (current == null) {
                    hm.put(percent, itemVATAmount);
                    continue;
                }
                hm.put(percent, current.add(itemVATAmount));
            }
        }
        if (this.trans.getZFCharges() != null) {
            for (IZUGFeRDAllowanceCharge charge : this.trans.getZFCharges()) {
                percent = charge.getTaxPercent();
                itemVATAmount = new VATAmount(charge.getTotalAmount(), charge.getTotalAmount().multiply(percent).divide(new BigDecimal(100)));
                current = hm.get(percent);
                if (current == null) {
                    hm.put(percent, itemVATAmount);
                    continue;
                }
                hm.put(percent, current.add(itemVATAmount));
            }
        }
        return hm;
    }

    @Deprecated
    public void PDFattachZugferdFile(IZUGFeRDExportableTransaction transaction) throws IOException, JAXBException {
        this.createPDFattachZUGFeRDFile(transaction);
    }

    public void createPDFattachZUGFeRDFile(IZUGFeRDExportableTransaction transaction) throws IOException, JAXBException {
        if (this.zugferdData == null) {
            byte[] zugferdRaw = this.getZugferdXMLForTransaction(transaction).getBytes();
            if (zugferdRaw[0] == -17 && zugferdRaw[1] == -69 && zugferdRaw[2] == -65) {
                this.zugferdData = new byte[zugferdRaw.length - 3];
                System.arraycopy(zugferdRaw, 3, this.zugferdData, 0, zugferdRaw.length - 3);
            } else {
                this.zugferdData = zugferdRaw;
            }
        }
        this.createPDFAttachGenericFile(this.doc, "ZUGFeRD-invoice.xml", "Alternative", "Invoice metadata conforming to ZUGFeRD standard (http://www.ferd-net.de/front_content.php?idcat=231&lang=4)", "text/xml", this.zugferdData);
    }

    public void export(String zUGFeRDfilename) {
        try {
            this.doc.save(zUGFeRDfilename);
        }
        catch (IOException e) {
            LOG.catching(e);
        }
    }

    @Deprecated
    public void PDFAttachGenericFile(PDDocument pddoc, String filename, String relationship, String description, String subType, byte[] data) throws IOException {
        this.createPDFAttachGenericFile(pddoc, filename, relationship, description, subType, data);
    }

    public void createPDFAttachGenericFile(PDDocument pddoc, String filename, String relationship, String description, String subType, byte[] data) throws IOException {
        PDComplexFileSpecification fs = new PDComplexFileSpecification();
        fs.setFile(filename);
        COSDictionary dict = fs.getCOSObject();
        dict.setName("AFRelationship", relationship);
        dict.setString("UF", filename);
        dict.setString("Desc", description);
        ByteArrayInputStream fakeFile = new ByteArrayInputStream(data);
        PDEmbeddedFile ef = new PDEmbeddedFile(pddoc, fakeFile);
        ef.setSubtype(subType);
        ef.setSize(data.length);
        ef.setCreationDate(new GregorianCalendar());
        ef.setModDate(Calendar.getInstance());
        fs.setEmbeddedFile(ef);
        dict = fs.getCOSObject();
        COSDictionary efDict = (COSDictionary)dict.getDictionaryObject(COSName.EF);
        COSBase lowerLevelFile = efDict.getItem(COSName.F);
        efDict.setItem(COSName.UF, lowerLevelFile);
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(pddoc.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = names.getEmbeddedFiles();
        if (efTree == null) {
            efTree = new PDEmbeddedFilesNameTreeNode();
        }
        HashMap<String, Object> namesMap = new HashMap<String, Object>();
        Map oldNamesMap = efTree.getNames();
        if (oldNamesMap != null) {
            for (String key : oldNamesMap.keySet()) {
                namesMap.put(key, oldNamesMap.get(key));
            }
        }
        namesMap.put(filename, fs);
        efTree.setNames(namesMap);
        names.setEmbeddedFiles(efTree);
        pddoc.getDocumentCatalog().setNames(names);
        COSArray cosArray = (COSArray)pddoc.getDocumentCatalog().getCOSObject().getItem("AF");
        if (cosArray == null) {
            cosArray = new COSArray();
        }
        cosArray.add(fs);
        COSDictionary dict2 = pddoc.getDocumentCatalog().getCOSObject();
        COSArray array = new COSArray();
        array.add(fs.getCOSObject());
        dict2.setItem("AF", (COSBase)array);
        pddoc.getDocumentCatalog().getCOSObject().setItem("AF", (COSBase)cosArray);
    }

    public void setZUGFeRDXMLData(byte[] zugferdData) {
        this.zugferdData = zugferdData;
    }

    public void setZUGFeRDConformanceLevel(String zUGFeRDConformanceLevel) {
        this.zUGFeRDConformanceLevel = zUGFeRDConformanceLevel;
    }

    private void addZugferdXMP(XMPMetadata metadata) {
        XMPSchemaPDFAExtensions pdfaex = new XMPSchemaPDFAExtensions(metadata);
        metadata.addSchema(pdfaex);
        XMPSchemaZugferd zf = new XMPSchemaZugferd(metadata, this.zUGFeRDConformanceLevel);
        metadata.addSchema(zf);
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    private class Totals {
        private BigDecimal totalNetAmount;
        private BigDecimal totalGrossAmount;
        private BigDecimal lineTotalAmount;
        private BigDecimal totalTaxAmount;

        public Totals() {
            BigDecimal res = BigDecimal.ZERO;
            for (IZUGFeRDExportableItem currentItem : ZUGFeRDExporter.this.trans.getZFItems()) {
                LineCalc lc = new LineCalc(currentItem);
                res = res.add(lc.getItemTotalNetAmount());
            }
            this.lineTotalAmount = res;
            if (ZUGFeRDExporter.this.trans.getZFAllowances() != null) {
                for (IZUGFeRDAllowanceCharge headerAllowance : ZUGFeRDExporter.this.trans.getZFAllowances()) {
                    res = res.subtract(headerAllowance.getTotalAmount());
                }
            }
            if (ZUGFeRDExporter.this.trans.getZFLogisticsServiceCharges() != null) {
                for (IZUGFeRDAllowanceCharge logisticsServiceCharge : ZUGFeRDExporter.this.trans.getZFLogisticsServiceCharges()) {
                    res = res.add(logisticsServiceCharge.getTotalAmount());
                }
            }
            if (ZUGFeRDExporter.this.trans.getZFCharges() != null) {
                for (IZUGFeRDAllowanceCharge charge : ZUGFeRDExporter.this.trans.getZFCharges()) {
                    res = res.add(charge.getTotalAmount());
                }
            }
            this.totalNetAmount = res;
            HashMap vatPercentAmountMap = ZUGFeRDExporter.this.getVATPercentAmountMap();
            for (BigDecimal currentTaxPercent : vatPercentAmountMap.keySet()) {
                VATAmount amount = (VATAmount)vatPercentAmountMap.get(currentTaxPercent);
                res = res.add(amount.getCalculated());
            }
            this.totalGrossAmount = res;
            this.totalTaxAmount = this.totalGrossAmount.subtract(this.totalNetAmount);
        }

        public BigDecimal getTotalNet() {
            return this.totalNetAmount;
        }

        public BigDecimal getTotalGross() {
            return this.totalGrossAmount;
        }

        public BigDecimal getLineTotal() {
            return this.lineTotalAmount;
        }

        public BigDecimal getTaxTotal() {
            return this.totalTaxAmount;
        }
    }

    private class LineCalc {
        private BigDecimal totalGross;
        private BigDecimal itemTotalNetAmount;
        private BigDecimal itemTotalVATAmount;
        private BigDecimal itemNetAmount;

        public LineCalc(IZUGFeRDExportableItem currentItem) {
            BigDecimal totalAllowance = BigDecimal.ZERO;
            BigDecimal totalCharge = BigDecimal.ZERO;
            if (currentItem.getItemAllowances() != null) {
                for (IZUGFeRDAllowanceCharge itemAllowance : currentItem.getItemAllowances()) {
                    totalAllowance = itemAllowance.getTotalAmount().add(totalAllowance);
                }
            }
            if (currentItem.getItemCharges() != null) {
                for (IZUGFeRDAllowanceCharge itemCharge : currentItem.getItemCharges()) {
                    totalCharge = itemCharge.getTotalAmount().add(totalCharge);
                }
            }
            BigDecimal multiplicator = currentItem.getProduct().getVATPercent().divide(new BigDecimal(100), 4, 4).add(BigDecimal.ONE);
            this.totalGross = currentItem.getPrice().multiply(currentItem.getQuantity()).subtract(totalAllowance).add(totalCharge).multiply(multiplicator);
            this.itemTotalNetAmount = currentItem.getPrice().multiply(currentItem.getQuantity()).subtract(totalAllowance).add(totalCharge).setScale(2, 4);
            this.itemTotalVATAmount = this.totalGross.subtract(this.itemTotalNetAmount);
            this.itemNetAmount = currentItem.getPrice().multiply(currentItem.getQuantity()).subtract(totalAllowance).add(totalCharge).divide(currentItem.getQuantity(), 4, 4);
        }

        public BigDecimal getItemTotalNetAmount() {
            return this.itemTotalNetAmount;
        }

        public BigDecimal getItemTotalVATAmount() {
            return this.itemTotalVATAmount;
        }

        public BigDecimal getItemNetAmount() {
            return this.itemNetAmount;
        }
    }
}

