/*
 * Decompiled with CFR 0.152.
 */
package de.print2forms.util.KeyCheck4J;

import de.print2forms.util.CRC32.CRC32;
import de.print2forms.util.DataTypeConverter;
import de.print2forms.util.KeyCheck4J.KeyCheckError;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class KeyCheck4J {
    private static final long ACCUMULATOR_START_VALUE = 1872031L;
    private static final long SALT = 1739L;
    private long crcStartValue = 2394877945L;
    private KeyCheckError error = KeyCheckError.None;
    private boolean debug = false;
    private int mode;
    long nowTimeStamp = System.currentTimeMillis() / 1000L;

    public boolean check(String key, int mode) {
        this.error = KeyCheckError.None;
        this.mode = mode;
        byte[] bytes = key.getBytes(StandardCharsets.US_ASCII);
        int[] ints = new int[bytes.length];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = bytes[i];
        }
        byte[] intsOut = new byte[256];
        this.descrambleKey(ints, ints.length, intsOut, intsOut.length);
        return KeyCheckError.None.equals((Object)this.error);
    }

    public boolean check(String key, int mode, long time) {
        this.nowTimeStamp = time;
        return this.check(key, mode);
    }

    private long decodeRadix64KeyPart(int[] in, int p) {
        long value = 0L;
        for (int i = 10 + p; i >= 0 + p; --i) {
            int c = in[i];
            if (c >= 97 && c <= 122) {
                c -= 97;
            } else if (c >= 65 && c <= 90) {
                c = c - 65 + 26;
            } else if (c >= 48 && c <= 57) {
                c = c - 48 + 52;
            } else if (c == 36) {
                c = 62;
            } else {
                if (c != 35) continue;
                c = 63;
            }
            value = value << 6 | (long)c;
        }
        return value;
    }

    private void descrambleKey(int[] intIn, int len, byte[] intsOut, int dstLen) {
        boolean isModeValid;
        int p = 0;
        int pszPlain = 0;
        int i = 0;
        int r = 0;
        do {
            if (i + 8 > dstLen) {
                return;
            }
            long bint = this.decodeRadix64KeyPart(intIn, p);
            byte[] bytes = ByteBuffer.allocate(8).putLong(bint).array();
            for (int k = 0; k < bytes.length; ++k) {
                intsOut[i + k] = bytes[bytes.length - 1 - k];
            }
            i += 8;
            p += 11;
        } while ((r += 11) < len);
        long accu = 1872031L;
        while (i-- > 0) {
            byte c = intsOut[pszPlain];
            int o = DataTypeConverter.byteToUnsignedInt(c);
            intsOut[pszPlain] = c = (byte)((long)c ^ accu & 0xFFL);
            ++pszPlain;
            accu += (long)o * 1739L;
            accu >>= 5;
        }
        int modeValue = DataTypeConverter.byteToUnsignedInt(intsOut[8]) << 8 | DataTypeConverter.byteToUnsignedInt(intsOut[9]);
        boolean bl = isModeValid = (modeValue & this.mode) > 0 && this.mode > 0;
        if (!isModeValid) {
            this.error = KeyCheckError.ModeInvalid;
        }
        if (this.debug) {
            System.out.printf("Mode Value: %16s\n", Integer.toBinaryString(modeValue));
            System.out.printf("Mode      : %16s\n", Integer.toBinaryString(this.mode));
            System.out.printf("------------------------------\n", new Object[0]);
            System.out.printf("    mode %s\n", isModeValid ? "ok" : "invalid");
        }
        long keyTimeStamp = DataTypeConverter.byteToUnsignedInt(intsOut[2]) | DataTypeConverter.byteToUnsignedInt(intsOut[3]) << 8 | DataTypeConverter.byteToUnsignedInt(intsOut[4]) << 16 | DataTypeConverter.byteToUnsignedInt(intsOut[5]) << 24;
        long difTimeStamp = this.nowTimeStamp - keyTimeStamp;
        long maxdiff = 10443L;
        if (this.debug) {
            System.out.println();
            System.out.printf("KeyTimeStamp: %16s\n", keyTimeStamp);
            System.out.printf("NowTimeStamp: %16s\n", this.nowTimeStamp);
            System.out.printf("        diff: %16s\n", difTimeStamp);
            System.out.printf("    max diff: %16s\n", maxdiff);
            System.out.printf("------------------------------\n", new Object[0]);
        }
        if (difTimeStamp < 0L) {
            if (this.debug) {
                System.out.printf("    error: Timestamp in future\n", maxdiff);
            }
            this.error = KeyCheckError.TimeStampFuture;
        } else if (difTimeStamp > maxdiff) {
            if (this.debug) {
                System.out.printf("    error: Timestamp expired\n", maxdiff);
            }
            this.error = KeyCheckError.TimeStampExpired;
        } else if (this.debug) {
            System.out.printf("    timestamp ok\n", maxdiff);
        }
        if (this.debug) {
            System.out.println();
        }
        long crc32 = DataTypeConverter.byteToUnsignedLong(intsOut[11]) | DataTypeConverter.byteToUnsignedLong(intsOut[13]) << 8 | DataTypeConverter.byteToUnsignedLong(intsOut[15]) << 16 | DataTypeConverter.byteToUnsignedLong(intsOut[17]) << 24;
        intsOut[11] = 0;
        intsOut[13] = 0;
        intsOut[15] = 0;
        intsOut[17] = 0;
        long crc32calced = CRC32.calc(intsOut, intsOut.length, this.crcStartValue);
        if (this.debug) {
            System.out.printf("CRC32 recieved: %16s\n", Long.toBinaryString(crc32));
            System.out.printf("CRC32   calced: %16s\n", Long.toBinaryString(crc32calced));
            System.out.printf("------------------------------\n", new Object[0]);
        }
        if (crc32 == crc32calced) {
            if (this.debug) {
                System.out.println("    crc32 ok");
            }
        } else {
            if (this.debug) {
                System.out.println("    crc32 error");
            }
            this.error = KeyCheckError.CheckSumError;
        }
    }

    public KeyCheckError getLastError() {
        return this.error;
    }

    public void setDebug(boolean isDebug) {
        this.debug = isDebug;
    }

    public void setCRCStartValue(long crcStartValue) {
        this.crcStartValue = crcStartValue;
    }
}

