/*
 * Decompiled with CFR 0.152.
 */
package de.print2forms.ZUGFeRD;

import de.print2forms.ZUGFeRD.ZUGFeRDStrategy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.apache.xmpbox.type.BadFieldValueException;

public class PCLStrategy
extends ZUGFeRDStrategy {
    private final String converterPath;
    private final String inpcl;
    private final String inxml;
    private static File inpdf = null;
    private Converter converter = Converter.GHOST_PCL;

    public PCLStrategy(String ghostPCL, String inpcl, String inxml) {
        this.converterPath = ghostPCL;
        this.inpcl = inpcl;
        this.inxml = inxml;
    }

    protected void pcl2pdfa() throws FileNotFoundException {
        Process p;
        ProcessBuilder pb;
        if (!Paths.get(this.inpcl, new String[0]).toFile().exists()) {
            throw new FileNotFoundException("inpcl \"" + this.inpcl + "\" not found.");
        }
        if (!Paths.get(this.inxml, new String[0]).toFile().exists()) {
            throw new FileNotFoundException("inxml \"" + this.inxml + "\" not found.");
        }
        try {
            inpdf = File.createTempFile("invoice", ".pdf");
        }
        catch (IOException e1) {
            throw new RuntimeException("Could not create temp file.");
        }
        switch (this.converter) {
            case LINC_PDF: {
                pb = new ProcessBuilder(this.converterPath.toString(), "-i" + this.inpcl, "-o" + inpdf.getAbsolutePath(), "-k:5", "-r:2", "-n:1.0", "-q1", "-pType:1", "-dAuthor:print2forms");
                break;
            }
            default: {
                pb = new ProcessBuilder(this.converterPath.toString(), "-o", inpdf.getAbsolutePath(), "-sPDFCompatibillityPolicy=2", "-sDEVICE=pdfwrite", "-dPDFA=1", "-dCompressPages=false", "-dCompressFonts=false", this.inpcl);
            }
        }
        try {
            p = pb.start();
        }
        catch (IOException e) {
            p = null;
        }
        this.waitWhileAlive(p);
    }

    private void waitWhileAlive(Process p) {
        if (p != null) {
            while (this.isAlive(p)) {
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private boolean isAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    @Override
    public void convert(String outpdf) throws JAXBException, IOException, TransformerException, BadFieldValueException {
        this.pcl2pdfa();
        this.zugferdFromPdfA1(outpdf, inpdf.getAbsolutePath(), this.inxml);
    }

    public static enum Converter {
        GHOST_PCL,
        LINC_PDF;

    }
}

