/*
 * Decompiled with CFR 0.152.
 */
package de.print2forms.ZUGFeRD;

import de.print2forms.ZUGFeRD.PCLStrategy;
import de.print2forms.ZUGFeRD.PDFA1Strategy;
import de.print2forms.ZUGFeRD.ZUGFeRDStrategy;
import de.print2forms.util.KeyCheck4J.KeyCheck4J;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.xmpbox.type.BadFieldValueException;

public final class Main {
    private static final int authMode = 64;

    private Main() {
    }

    public static void showHelp(OptionParser parser) {
        try {
            parser.printHelpOn(System.out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.println("There are two ways to use p2fzugferd depending on the type of input. (1) use a .pcl (--inpcl) and ghostpcl (--gpdl) to create the pdf or (2) use an pdf/a (--inpdf) as input. in every case, an xml (--xml) and an output path for the generated pdf (--outpdf) is required. In any case a key generated by print2forms (--key) is required for p2fZugferd to run.");
    }

    public static void main(String[] args) throws JAXBException, IOException, TransformerException, BadFieldValueException {
        OptionParser parser = new OptionParser();
        parser.accepts("xml").withRequiredArg().required().ofType(String.class).describedAs("Path to ZUGFeRD-XML-File to attach");
        parser.accepts("inpdf").withRequiredArg().ofType(String.class).describedAs("Path to PDF/A-1 compatible invoice pdf file");
        parser.accepts("inpcl").withRequiredArg().ofType(String.class).describedAs("Path to pcl file");
        parser.accepts("gpdl").withRequiredArg().ofType(String.class).describedAs("Path to ghostpcl executable");
        parser.accepts("outpdf").withRequiredArg().required().ofType(String.class).describedAs("Path to output the created ZUGFeRD compatible pdf");
        parser.accepts("key").withRequiredArg().required().ofType(String.class).describedAs("The license key generated by a print2forms gateway authorizing p2fZugferd to be run.");
        parser.accepts("linc").withRequiredArg().ofType(String.class).describedAs("Path to LincPDF. Can be used instead of --gpdl");
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (Exception e) {
            Main.showHelp(parser);
            return;
        }
        ZUGFeRDStrategy strat = null;
        if (!options.has("key")) {
            System.err.println("Key (--key) missing");
            Main.showHelp(parser);
            return;
        }
        KeyCheck4J keyChecker = new KeyCheck4J();
        String key = (String)options.valueOf("key");
        if (!keyChecker.check(key, 64)) {
            System.err.println("Invalid Key");
            return;
        }
        if ((options.has("gpdl") || options.has("linc")) && options.has("inpcl") && options.has("xml") && options.has("outpdf")) {
            String path = options.has("gpdl") ? options.valueOf("gpdl").toString() : options.valueOf("linc").toString();
            strat = new PCLStrategy(path, options.valueOf("inpcl").toString(), options.valueOf("xml").toString());
        } else if (options.has("inpdf") && options.has("xml") && options.has("outpdf")) {
            strat = new PDFA1Strategy(options.valueOf("inpdf").toString(), options.valueOf("xml").toString());
        } else {
            Main.showHelp(parser);
            return;
        }
        ((ZUGFeRDStrategy)strat).convert(options.valueOf("outpdf").toString());
    }
}

