/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ZUGFeRDImporter {
    private static final Logger LOG = LogManager.getLogger();
    private boolean containsMeta = false;
    private String foreignReference;
    private String bic;
    private String iban;
    private String holder;
    private String amount;
    private String dueDate;
    private byte[] rawXML = null;
    private String bankName;
    private boolean amountFound;
    private boolean extracted = false;
    private boolean parsed = false;
    private final String errmessage = "use parse() before requesting a value";

    public void extract(String pdfFilename) {
        try {
            this.extractLowLevel(new BufferedInputStream(new FileInputStream(pdfFilename)));
        }
        catch (IOException ioe) {
            LOG.error("Error extract PDF file", (Throwable)ioe);
        }
    }

    public void extractLowLevel(InputStream pdfStream) throws IOException {
        try (PDDocument doc = PDDocument.load(pdfStream);){
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode etn = names.getEmbeddedFiles();
            if (etn == null) {
                doc.close();
                return;
            }
            Map efMap = etn.getNames();
            for (String filename : efMap.keySet()) {
                if (!"ZUGFeRD-invoice.xml".equals(filename)) continue;
                this.containsMeta = true;
                PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)efMap.get(filename);
                PDEmbeddedFile embeddedFile = fileSpec.getEmbeddedFile();
                this.rawXML = embeddedFile.toByteArray();
                this.setMeta(new String(this.rawXML));
                this.extracted = true;
            }
        }
    }

    public void parse() throws ParserConfigurationException, IOException, SAXException {
        Node detail;
        int detailIndex;
        NodeList bookingDetails;
        Node booking;
        int bookingIndex;
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document document = null;
        if (!this.extracted) {
            throw new RuntimeException("extract() or extractLowLevel() must be used before parsing.");
        }
        factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        builder = factory.newDocumentBuilder();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.rawXML);){
            document = builder.parse(bais);
        }
        NodeList ndList = document.getDocumentElement().getElementsByTagNameNS("*", "PaymentReference");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            this.setForeignReference(booking.getTextContent());
        }
        ndList = document.getElementsByTagNameNS("*", "PayeePartyCreditorFinancialAccount");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            bookingDetails = booking.getChildNodes();
            for (detailIndex = 0; detailIndex < bookingDetails.getLength(); ++detailIndex) {
                detail = bookingDetails.item(detailIndex);
                if (detail.getLocalName() == null || !detail.getLocalName().equals("IBANID")) continue;
                this.setIBAN(detail.getTextContent());
            }
        }
        ndList = document.getElementsByTagNameNS("*", "PayeeSpecifiedCreditorFinancialInstitution");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            bookingDetails = booking.getChildNodes();
            for (detailIndex = 0; detailIndex < bookingDetails.getLength(); ++detailIndex) {
                detail = bookingDetails.item(detailIndex);
                if (detail.getLocalName() != null && detail.getLocalName().equals("BICID")) {
                    this.setBIC(detail.getTextContent());
                }
                if (detail.getLocalName() == null || !detail.getLocalName().equals("Name")) continue;
                this.setBankName(detail.getTextContent());
            }
        }
        ndList = document.getElementsByTagNameNS("*", "SellerTradeParty");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            bookingDetails = booking.getChildNodes();
            for (detailIndex = 0; detailIndex < bookingDetails.getLength(); ++detailIndex) {
                detail = bookingDetails.item(detailIndex);
                if (detail.getLocalName() == null || !detail.getLocalName().equals("Name")) continue;
                this.setHolder(detail.getTextContent());
            }
        }
        ndList = document.getElementsByTagNameNS("*", "DuePayableAmount");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            this.amountFound = true;
            this.setAmount(booking.getTextContent());
        }
        if (!this.amountFound) {
            ndList = document.getElementsByTagNameNS("*", "GrandTotalAmount");
            for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
                booking = ndList.item(bookingIndex);
                this.amountFound = true;
                this.setAmount(booking.getTextContent());
            }
        }
        ndList = document.getElementsByTagNameNS("*", "SpecifiedTradePaymentTerms");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            bookingDetails = booking.getChildNodes();
            for (detailIndex = 0; detailIndex < bookingDetails.getLength(); ++detailIndex) {
                detail = bookingDetails.item(detailIndex);
                if (detail.getLocalName() == null || !detail.getLocalName().equals("DueDateDateTime")) continue;
                this.setDueDate(detail.getTextContent().trim());
            }
        }
        this.parsed = true;
    }

    public boolean containsMeta() {
        return this.containsMeta;
    }

    public String getForeignReference() {
        if (!this.parsed) {
            throw new RuntimeException("use parse() before requesting a value");
        }
        return this.foreignReference;
    }

    private void setForeignReference(String foreignReference) {
        this.foreignReference = foreignReference;
    }

    public String getBIC() {
        if (!this.parsed) {
            throw new RuntimeException("use parse() before requesting a value");
        }
        return this.bic;
    }

    private void setBIC(String bic) {
        this.bic = bic;
    }

    private void setDueDate(String dueDate) {
        this.dueDate = dueDate;
    }

    private void setBankName(String bankname) {
        this.bankName = bankname;
    }

    public String getIBAN() {
        if (!this.parsed) {
            throw new RuntimeException("use parse() before requesting a value");
        }
        return this.iban;
    }

    public String getBankName() {
        if (!this.parsed) {
            throw new RuntimeException("use parse() before requesting a value");
        }
        return this.bankName;
    }

    private void setIBAN(String iban) {
        this.iban = iban;
    }

    public String getHolder() {
        if (this.rawXML == null) {
            throw new RuntimeException("use parse() before requesting a value");
        }
        return this.holder;
    }

    private void setHolder(String holder) {
        this.holder = holder;
    }

    public String getAmount() {
        if (this.rawXML == null) {
            throw new RuntimeException("use parse() before requesting a value");
        }
        return this.amount;
    }

    public String getDueDate() {
        if (this.rawXML == null) {
            throw new RuntimeException("use parse() before requesting a value");
        }
        return this.dueDate;
    }

    private void setAmount(String amount) {
        this.amount = amount;
    }

    public void setMeta(String meta) {
        this.rawXML = meta.getBytes();
    }

    public String getMeta() {
        if (this.rawXML == null) {
            return null;
        }
        return new String(this.rawXML);
    }

    public byte[] getRawXML() {
        return this.rawXML;
    }

    public boolean canParse() {
        String meta = this.getMeta();
        return meta != null && meta.length() > 0 && meta.contains("SpecifiedExchangedDocumentContext");
    }
}

